using System.Collections;
using UnityEngine;
using FMOD.Studio;

public class MainTheme : MonoBehaviour
{
    public static MainTheme instance;
    private EventInstance mainTheme;

    void Awake()
    {
        if (instance != null && instance != this)
        {
            Destroy(gameObject);
            return;
        }

        instance = this;
        DontDestroyOnLoad(gameObject);
    }

    void Start()
    {
        mainTheme = AudioManager.instance.CreateEventInstance(FMODEvents.instance.MainTheme);
        mainTheme.start();
    }

    public void StopMainTheme()
    {
        mainTheme.stop(STOP_MODE.ALLOWFADEOUT);
        mainTheme.release();
        Destroy(gameObject); 
    }
}
