using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using FMODUnity;

public class FMODEvents : MonoBehaviour
{
    [field: Header("PLAYERS")]
    [field: SerializeField] public EventReference footsteps { get; private set;}
    [field: SerializeField] public EventReference handshake { get; private set;}
    [field: SerializeField] public EventReference cash { get; private set;}
    
    [field: Header("AI")]
    [field: SerializeField] public EventReference flashSound { get; private set;}
    [field: SerializeField] public EventReference muttering { get; private set;}

    [field: Header("UI")]
    [field: SerializeField] public EventReference UIclick { get; private set;}
    [field: SerializeField] public EventReference gameStart { get; private set;}
    [field: SerializeField] public EventReference gameOver { get; private set;}
    [field: SerializeField] public EventReference typewriter { get; private set;}
    [field: SerializeField] public EventReference introMusic { get; private set;}

    [field: Header("ENVIRONEMENT")]
    [field: SerializeField] public EventReference crowdNoise { get; private set;}
    [field: SerializeField] public EventReference levelMusic { get; private set;}
    [field: SerializeField] public EventReference MainTheme { get; private set;}

    [field: Header("testSound1")]
    [field: SerializeField] public EventReference testSound1 { get; private set;}


    public static FMODEvents instance { get; private set; } 

    private void Awake()
    {
        if (instance != null)
        {
            Debug.LogError("Found more than one FMOD Events script in the scene");
        }
        instance = this;
    }
}
