using UnityEngine;
using Cinemachine;

public class CameraSwitcher : MonoBehaviour
{
    public CinemachineVirtualCamera[] virtualCameras;
    private CinemachineBrain cinemachineBrain;

    private void Start()
    {
        cinemachineBrain = FindObjectOfType<CinemachineBrain>();
        // Deactivate all cameras initially
        foreach (var vc in virtualCameras)
        {
            vc.gameObject.SetActive(false);
        }
    }

    public void SwitchCamera(int index)
    {
        if (index >= 0 && index < virtualCameras.Length)
        {
            // Activate the selected camera and deactivate others
            for (int i = 0; i < virtualCameras.Length; i++)
            {
                virtualCameras[i].gameObject.SetActive(i == index);
            }
        }
    }
}
